#include common_scripts\utility;
#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
#include user_scripts\mp_patches\hawkins\setup;
#include user_scripts\mp_patches\hawkins\mapUtils;

init()
{
	level.spawnz=0;
	level.doCustomMap=0;
	level.doorwait=2;
	level.BuildingWorld = 1;
	precacheModel("prop_flag_neutral");
	precacheModel("h1_flag_mp_domination_usmc_blue");
	precacheModel("h1_flag_mp_domination_usmc_red");
	precacheModel("vehicle_m1a1_abrams_dmg");
	level thread CreateDeathZones();
	level.gameState="starting";

	wait 1;
	if(getDvar("mapname") == "mp_afghan")
	{
		/** Derail **/ switch(randomInt(2))
		{
			case 0: level Afghan();
			level.edit = 0;
			break;
			case 1: level Afghan2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_boneyard")
	{
		/** Scrapyard **/ switch(randomInt(1))
		{
			case 0: level Scrapyard();
			level.edit = 0;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_brecourt")
	{
		/** Wasteland **/ switch(randomInt(3))
		{
			case 0: level Wasteland2();
			level.edit = 0;
			break;
			case 1: level Wasteland2();
			level.edit = 1;
			break;
			case 2: level Wasteland2();
			level.edit = 2;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_checkpoint")
	{
		/** Karachi **/ switch(randomInt(2))
		{
			case 0: level Karachi();
			level.edit = 0;
			break;
			case 1: level Karachi2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_derail")
	{
		/** Derail **/ switch(randomInt(2))
		{
			case 0: level Derail();
			level.edit = 0;
			break;
			case 1: level Derail2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname")== "mp_estate")
	{
		/** Estate **/ switch(randomInt(2))
		{
			case 0: level Estate();//. CP-count = 186
			level.edit = 0;
			break;
			case 1: level Estate();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_favela")
	{
		/** Favela **/ switch(randomInt(2))
		{
			case 0: level Favela();
			level.edit = 0;
			break;
			case 1: level Favela2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_highrise")
	{
		/** Highrise **/ switch(randomInt(2))
		{
			case 0: level Highrise();
			level.edit = 0;
			break;
			case 1: level Highrise2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_nightshift")
	{
		/** Skidrow **/ switch(randomInt(3))
		{
			case 0: level Skidrow();
			level.edit = 0;
			break;
			case 1: level Skidrow2();
			level.edit = 1;
			break;
			case 2: level Skidrow3();
			level.edit = 2;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_invasion")
	{
		/** Invasion **/ switch(randomInt(2))
		{
			case 0: level Invasion();
			level.edit = 0;
			break;
			case 1: level Invasion2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_quarry")
	{
		/** Quarry **/ switch(randomInt(2))
		{
			case 0: level Quarry();
			level.edit = 0;
			break;
			case 1: level Quarry2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_rundown")
	{
		/** Rundown **/ switch(randomInt(3))
		{
			case 0: level Rundown();
			level.edit = 0;
			break;
			case 1: level Rundown2();
			level.edit = 1;
			break;
			case 2: level Rundown3();
			level.edit = 2;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_rust")
	{
		/** Rust **/ switch(randomInt(3))
		{
			case 0: level Rust();
			level.edit = 0;
			break;
			case 1: level Rust2();
			level.edit = 1;
			break;
			case 2: level Rust3();
			level.edit = 2;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_subbase")
	{
		/** Subbase **/ switch(randomInt(2))
		{
			case 0: level SubBase();
			level.edit = 0;
			break;
			case 1: level SubBase2();
			level.edit = 1;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_terminal")
	{
		/** Terminal **/ switch(randomInt(2))
		{
			case 0: level Terminal();//Other build. CP-count = 225
			level.edit = 0;
			break;
			case 1: level Terminal3();//Above Turrent and Out of map dinner.. CP-count = 250
			level.edit = 2;
			break;
			//case 2: level loadBuild("TheUncleBobbyB");
			//level.edit = 3;
			//break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_underpass")
	{
		/** Underpass **/ switch(randomInt(3))
		{
			case 0: level Underpass();
			level.edit = 0;
			break;
			case 1: level Underpass2();
			level.edit = 1;
			break;
			case 2: level Underpass3();
			level.edit = 2;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_storm" || getDvar("mapname") == "mp_storm_spring" )
	{
		switch(randomInt(1))
		{
			case 0: level Storm();
			level.edit = 0;
			break;
		}
		level.doCustomMap = 1;
	}
	if(getDvar("mapname") == "mp_nuked" )
	{
		switch(randomInt(1))
		{
			case 0: level NukeTown();
			level.edit = 0;
			break;
		}
		level.doCustomMap = 1;
	}
	level notify("CREATED");
	level.BuildingWorld = 0;
	foreach(player in level.players)
	{
		player notify("MapBuilt");
	}
	thread MySafe();
}
MySafe()
{
	wait 5;
	level.BuildingWorld = 0;
	level notify("CREATED");
}
ZKillTrigger( pos, radius, height )
{
	level endon("glitches");
	trig = spawn( "trigger_radius", pos, radius, radius, height );
	for (;;)
	{
		trig waittill( "trigger", player );
		if ( !isPlayer( player ) ) continue;
		player suicide();
	}
}
CreateDeathZones()
{
	switch(getDvar("mapname"))
	{
		case "mp_afghan": 
		level thread ZKillTrigger((922.589,1544.54,486.125),50,10);
		level thread ZKillTrigger((4411,1025,187),50,10);
		level thread ZKillTrigger((2007,4644,227),50,10);
		break;
		case "mp_derail": 
		level thread ZKillTrigger((-655,-3277,211),50,10);
		level thread ZKillTrigger((2122,3812,385),50,10);
		level thread ZKillTrigger((1606,1096,231),50,10);
		break;
		case "mp_favela": 
		level thread ZKillTrigger((-1457,351,150),50,10);
		level thread ZKillTrigger((-1701,758,148),50,10);
		break;
		case "mp_checkpoint": 
		level thread ZKillTrigger((-1487,596,218),50,10);
		level thread ZKillTrigger((-1487,743,218),50,10);
		level thread ZKillTrigger((-1535,-555,93),50,10);
		level thread ZKillTrigger((-1833,-451,84),50,10);
		level thread ZKillTrigger((-347,-2551,128),50,10);
		level thread ZKillTrigger((235,1871,158),50,10);
		break;
		case "mp_nightshift": 
		level thread ZKillTrigger((-1612,-1578,95),50,10);
		level thread ZKillTrigger((-1048,-945,254),50,10);
		level thread ZKillTrigger((1137,333,224),50,10);
		level thread ZKillTrigger((707,317,226),50,10);
		break;
		case "mp_subbase": 
		level thread ZKillTrigger((999,1265,164),50,10);
		level thread ZKillTrigger((521,-916,348),50,10);
		break;
		case "mp_underpass": 
		level thread ZKillTrigger((3761,-70,460),50,10);
		break;
		case "mp_invasion": 
		level thread ZKillTrigger((-2980,-1115,368),50,10);
		level thread ZKillTrigger((-3359,-1199,395),50,10);
		level thread ZKillTrigger((-118,3078,245),50,10);
		level thread ZKillTrigger((-1160,3191,281),50,10);
		break;
	}
}
Afghan()
{
	CreateBlocks((3383,235,200),(90,0,90));
	CreateAsc((3430,-154,160),(3430,-154,347),0,5);
	CreateAsc((2496,795,83),(2517,914,231),0,5);
	CreateDoor("force",(1611,-252,136),(1611,-158,136),(90,0,0),3,2,55,100);
	CreateDoor("force",(2780,882,200),(2780,796,200),(90,0,0),3,2,55,100);
	CreateWalls((3150,289,106),(2989,301,205));
	CreateBlocks((3190,318,190),(0,0,90));
	CreateDoor("force",(3479,241,118),(3560,241,118),(90,0,90),6,2,55,100);
	CreateBlocks((2295,-55,140),(0,90,0));
	CreateBlocks((2295,-137,140),(0,90,0));
	CreateBlocks((2295,-99,140),(0,90,0));
	CreateDoor("force",(824,1635,182),(824,1469,182),(90,0,0),10,1,55,85);
	CreateDoor("force",(-113,1567,243),(-113,1508,243),(90,0,0),4,1,55,85);
	CreateBlocks((584,1835,180),0,90,0);
}
Afghan2()
{
	createFlag((1521, 1215, 53), (2700, 5645, 340), (0, -65, 0));
	CreateAdaptWalls((2665, 5845, 265), (3475, 4345, 585), 4, 0);
	CreateAdaptWalls((2385, 4765, 520), (2900, 4975, 560), 1, 0);
	CreateAdaptWalls((2385, 4765, 1000), (2900, 4975, 1000), 2, 30);
	createFlag((2015, 4470, 235), (2700, 5645, 340), (0, -65, 0));
	createFlag((2486, 4484, 635), (-588, -770, -70), (0, -65, 0));
	CreateDoor("force",(2840,4920,617),(3020,4989,611),(90,25,90),6,1,50,75);
	createFlag((3354, 5069, 467), (2700, 5645, 340), (0, -65, 0));
}
Derail()
{
	CreateDoor("force",(405,1239,117),(405,1320,117),(90,0,0),6,2,50,75);
	CreateDoor("force",(369,1273,338),(320,1273,338),(90,0,90),2,1,25,85);
	CreateDoor("force",(135,801,338),(185,801,338),(90,0,90),2,1,25,85);
	CreateDoor("force",(59,416,117),(-50,416,117),(90,0,90),8,2,50,75);
	createFlag((-106,2405,130),(-125,2219,343));
	CreateRamps((-124,2002,437),(-124,2189,332));
	CreateWalls((-170,2283,342),(-170,2023,389));
	CreateWalls((-75,2283,342),(-75,2023,389));
	CreateWalls((-165,2290,330),(-85,2290,389));
	createFlag((155,526,580),(-111,2625,250));
	ScreateSecretFlag((-710,3887,142),(812,1051,300));
	ScreateSecretFlag((1968,1080,76),(828,370,475));
	CreateGrids((770,286,400),(909,541,400),(0,0,0));
	CreateGrids((1344,2948,320),(1446,3165,320),(0,0,0));
	createFlag((909,525,420),(2899,1167,274),(0,0,0));
	createFlag((1336,3152,355),(2899,1167,274),(0,0,0));
	createFlag((2899,1630,254),(1394,3039,426),(0,0,0));
	createFlag((2201,2633,150),(557,2516,331),(0,0,0));
	CreateBlocks((-262,1547,508),(0,90,0));
	CreateBlocks((-262,1475,508),(0,90,0));
}
Derail2()
{
	createFlag((-110, 2398, 124), (-125, 2263, 333), (0, 270, 0));
	CreateRamps((-124, 2002, 437), (-124, 2189, 332));
	CreateWalls((937, -4025, 131), (995, -5536, 191));
	CreateWalls((593, -5536, 131), (625, -3981, 191));
	CreateIWall((937, -4025, 191), (995, -5536, 310));
	CreateIWall((593, -5536, 191), (625, -3981, 310));
	CreateBlocks((700, -4475, 130), (0, 0, 0));
	CreateWalls((569, -4520, 130), (978, -4520, 178));
	CreateWalls((960, -5052, 130), (623, -5126, 160));
	createFlag((177, 505, 617), (95, -2598, 340));
	createFlag((1002, -3660, 119), (788, -3860, 188));
	createFlag((944, -6079, 140), (95, -2598, 340));
	CreateDoor("door",(780, -5621, 114), (946, -5621, 114), (0, 0, 90), 4, 4, 70, 150);
	createFlag((1182, 2878, 140), (538, -3273, 127));
	createFlag((538, -2973, 127), (1182, 2978, 150));
	CreateBlocks((896, -4551, 130), (0, 0, 0));
	CreateGrids((720, -5203, 240), (935, -5291, 240), 0);
	createFlag((759, -6079, 140), (839, -5274, 275));
	ScreateSecretFlag((-2399, 390, 60), (700, 4717, 340));
	ScreateSecretFlag((3020, -2101, 70), (77, 3997, 157), (0, 180, 0));
	ScreateSecretFlag((-141, 4402, 175), (77, 3997, 157));
	createFlag((-619, 4440, 335), (264, 2904, 195));
	CreateRamps((-458, 4381, 311), (-458, 4034, 130));
	CreateIWall((-85, 3947, 170), (-85, 4357, 200));
	CreateBlocks((-45, 4347, 130), 0);
	CreateFire((-461, 4017, 150));
	/*CreateFire((-129, 1966, 453));*/ 
	CreateTWall((400, 5800, 450), (788, -3860, 188), 900);
	CreateTWall((700, 5800, 450), (788, -3860, 188), 900);
}
Estate()
{
	createFlag((588, 917, 465), (159, 378, 539), (0, 0, 0));
	createFlag((114, 1214, 925), (-1284, 1504, 920), (0, 0, 0));
	CreateBlocks((-371, 919, 245), (0, 100, 90));
	CreateBlocks((-383, 991, 245), (0, 100, 90));
	CreateBlocks((-349, 1115, 245), (0, 50, 90));
	CreateBlocks((-302, 1166, 245), (0, 50, 90));
	CreateBlocks((-55, 1231, 245), (0, -20, 90));
	CreateBlocks((8, 1217, 245), (0, -20, 90));
	CreateBlocks((102, 1188, 245), (0, -20, 90));
	CreateBlocks((162, 1168, 245), (0, -20, 90));
	CreateBlocks((1333, -92, 210), (0, 0, 90));
	CreateBlocks((-336, 739, 705), (0, 100, 90));
	CreateRamps((-344, 768, 710), (-214, 1252, 920));
	CreateGrids((-171, 1266, 920), (106, 830, 920), (0, 0, 0));
	CreateBlocks((-216, 1279, 920), (0, 0, 0));
	CreateDoor("door",(-320, 1002, 840), (-260, 1002, 840), (0, -15, 90), 6, 2, 40, 75);
	CreateDoor("door",(-300, 1148, 910), (-240, 1148, 910), (0, -15, 90), 6, 2, 40, 100);
	createFlag((-1230, 1193, -390), (-1543, 3205, 970), (0, -152, 0));
	CreateHiddenFlag((-172, 1298, 875), (-1543, 3205, 970), (0, -152, 0));
	createFlag((-675, 2037, -105), (1181, 2762 ,970), (0, 0, 0));
	CreateRamps((-3500, 3217, 260), (-3122, 3131, -115));
	//CreateBlocks((-430, 1026, 940), (0, 100, 90));
	//CreateBlocks((-430, 1075, 965), (0, 100, 90));
	createFlag((127, 627, 329), (384, 546, 465), (0, 0, 0));
	CreateRamps((-325, 721, 700), (-42, 729, 649));
	CreateRamps((15, 742, 649), (65, 928, 630));
	CreateBlocks((-3213, 1132, -156), (0, 90, 90));
	CreateBlocks((-3213, 1082, -156), (0, 90, 90));
	CreateBlocks((-3213, 1007, -156), (0, 90, 90));
	createFlag((-4469, 2689, -289), (1197, 3957, 157), (0, 0, 0));
	createFlag((669, 929, 563), (828, 822, 330), (0, 0, 0));
	//CreateRamps((-506.143, 1053.75, 976.286), (-403.282, 649.006, 729.349));
	//CreateRamps((-403.282, 649.006, 729.349), (5, 540.669, 729.349));
	ScreateSecretFlag((-1923, 3851, 235), (-5, 544, 770), (0, -76, 0));
	CreateBlocks((-1923.3, 3851.14, 220.149), (0, 90, 90));
	CreateAsc((455,813,650), (155,813,920), 0, 5);
}
Estate2()
{
	ScreateSecretFlag((-1923, 3851, 235), (-5, 544, 770), (0, -76, 0));
}
Favela()
{
	level thread CreateKillIfBelow(-5880);
	CreateWalls((2445,3065,280),(2583,2863,310));
	CreateWalls((2445,3065,340),(2583,2863,370));
	CreateWalls((2130,2613,280),(2081,2712,310));
	CreateWalls((2130,2613,340),(2081,2712,370));
	createFlag((880,2254,282),(1177,2402 ,281),(0,0,0));
	createFlag((2404,2992,280),(10555.5,18403.8,13635.1),(0,177.408,0));
	CreateDoor("force",(2081,2712,300),(2028,2780,300),(90,90,55),3,2,55,100);
	CreateBlocks((9967.6,18352.8,13633.5),(90,90,90));
	CreateAsc((10010.5,18404.3,13635.1),(10047.6,18425,13864.9),0,5);
	createFlag((9386,18434,13645),(431,2040,1528));
	CreateBlocks((-2315.64,5495,350),(90,90,90));
	CreateBlocks((-2231.83,737.505,110),(90,90,90));
	createFlag((496,175,5),(215.916,2228.5,281.523));
	CreateBlocks((10592.2,18406,13675),(90,90,90));
	CreateBlocks((10558,18452,13675),(90,90,90));
	CreateBlocks((10558,18353.4,13675),(90,90,90));
	createFlag((2484,2792,280),(-184,-715,72));
	CreateTWall((10010,18404,9000),(-1450,2658,590),4000);
	createFlag((-2315,5404,307),(591,1285,384));
	createFlag((474,887,355),(431,2000,1528));
	CreateDoor("force",(1481,913,220),(1483,967,220),(90,90,0),1,1,30,90);
	createFlag((427,1238,459),(1617,855,211));
	createFlag((1567,1085,211),(431,2040,1528));
	CreateDoor("force",(-1530,-591,75),(-1440,-591,90),(0,0,0),1,1,30,100);
	CreateIWall((-1623,-276,65),(-1708,-515,125));
	CreateIWall((-1708,-515,125),(-1529,-585,65));
	CreateIWall((-1529,-585,125),(-1351,-926,5));
	createFlag((-1244,-560,18),(-1255,-669,13));
	CreateRamps((-1452,-600,55),(-1423,-765,0));
	createFlag((-1639,-412,51),(-746,-1735,50));
	createFlag((-410,-1211,65),(-515,644,459));
	CreateFire((-741,-1246,59));
	CreateIWall((-757,-1576,68),(-387,-1576,98));
	CreateIWall((-380,-1374,80),(-621,-1380,110));
	CreateIWall((-621,-1380,110),(-661,-1182,80));
	CreateIWall((-617,-1785,120),(-219,-1798,90));
	createFlag((-938,3145,295),(-1011,2967,300));
	CreateIBlock((-836,-1032,163),(0,90,0));
	CreateBlocks((-332,-1153,163),(0,90,0));
	CreateIBlock((-836,-1032,133),(0,90,0));
	CreateBlocks((-302,-1153,163),(0,90,0));
	CreateTWall((-979,-1244,220),(-515,644,459),120);
	CreateBlocks((1122, -285, 160), (0, 0, 90));
}
Favela2()
{
	level thread CreateKillIfBelow(-5880);
	CreateBlocks((1122, -285, 160), (0, 0, 90));
	/*block to prevent further access under the map angles may need changing though*/ 
	createFlag((-479, -1949, 11), (-10,12,170), (0, 90, 0));
	/*flag outside of map to get back inside*/ 
	createFlag((1832, 902, 375), (-997, -1203, 193), (0, 90, 0));
	CreateTWall((10010,18404,9000), (2049, 890, 424), 4000);
	createFlag((8611, 18539, 13813), (10007, 18415, 13853), (0, 180, 0));
	createFlag((-146, 2600, 342), (9849, 18418, 13635), (0, 180, 0));
	createFlag((-1156, 310, 4), (9849, 18418, 13635), (0, 180, 0));
	createFlag((1224, 624, 185), (9849, 18418, 13635), (0, 180, 0));
	CreateRamps((8950, 18429, 13660), (9350, 18429, 13620));
	CreateRamps((8950, 18379, 13660), (9350, 18382, 13620));
	CreateRamps((8950, 18482, 13660), (9350, 18482, 13620));
	CreateRamps((8600, 18429, 13660), (8950, 18429, 13660));
	CreateRamps((8600, 18379, 13660), (8950, 18379, 13660));
	CreateRamps((8600, 18482, 13660), (8950, 18482, 13660));
	CreateRamps((8600, 18325, 13660), (8950, 18325, 13660));
	CreateRamps((8600, 18530, 13660), (8950, 18530, 13660));
	CreateWalls((8953, 18365, 13650), (8953, 18312, 13700));
	CreateWalls((8953, 18365, 13725), (8953, 18312, 13815));
	CreateWalls((8953, 18542, 13650), (8953, 18490, 13700));
	CreateWalls((8953, 18542, 13725), (8953, 18490, 13815));
	CreateWalls((8949, 18312, 13650), (8610, 18312, 13815));
	CreateWalls((8610, 18539, 13650), (8949, 18539, 13815));
	CreateWalls((8610, 18312, 13650), (8610, 18539, 13815));
	CreateWalls((8953, 18365, 13760), (8953, 18490, 13805));
	CreateRamps((8949, 18518, 13770), (8610, 18518, 13770));
	CreateRamps((8949, 18330, 13770), (8610, 18330, 13770));
	CreateRamps((8644, 18342, 13774), (8644, 18460, 13670));
	CreateRamps((8920, 18347, 13770), (8920, 18502, 13770));
	CreateDoor("door",(8955, 18428, 13780), (8955, 18428, 13700), (90, 0, 0), 3, 1, 20, 60);
	CreateRamps((8908, 18230, 13850), (8908, 18300, 13810));
	CreateRamps((9100, 18220, 13845), (8895, 18220, 13845));
	CreateRamps((8908, 18615, 13850), (8908, 18545, 13810));
	CreateRamps((9100, 18620, 13845), (8895, 18620, 13845));
	CreateBlocks((9100, 18219, 13865), (0, 90, 90));
	CreateBlocks((9086, 18182, 13865), (0, 0, 270));
	CreateBlocks((9086, 18259, 13865), (0, 0, 90));
	CreateBlocks((9030, 18182, 13865), (0, 0, 270));
	CreateBlocks((9030, 18259, 13865), (0, 0, 90));
	CreateBlocks((8975, 18182, 13865), (0, 0, 270));
	CreateBlocks((8975, 18259, 13865), (0, 0, 90));
	CreateBlocks((8909, 18182, 13865), (0, 0, 270));
	CreateBlocks((8930, 18182, 13865), (0, 0, 270));
	CreateBlocks((8882, 18182, 13865), (0, 0, 270));
	CreateBlocks((8867, 18219, 13865), (0, 90, 90));
	CreateBlocks((9100, 18620, 13865), (0, 90, 90));
	CreateBlocks((9086, 18578, 13865), (0, 0, 270));
	CreateBlocks((9086, 18655, 13865), (0, 0, 90));
	CreateBlocks((9030, 18578, 13865), (0, 0, 270));
	CreateBlocks((9030, 18655, 13865), (0, 0, 90));
	CreateBlocks((8975, 18578, 13865), (0, 0, 270));
	CreateBlocks((8975, 18655, 13865), (0, 0, 90));
	CreateBlocks((8930, 18655, 13865), (0, 0, 270));
	CreateBlocks((8909, 18655, 13865), (0, 0, 270));
	CreateBlocks((8882, 18655, 13865), (0, 0, 270));
	CreateBlocks((8867, 18620, 13865), (0, 90, 90));
	CreateGrids((9874, 18353, 13840), (10007, 18477, 13840), (0, 0, 0));
	CreateBlocks((9810, 18476, 13640), (0, 0, 270));
	CreateBlocks((9750, 18476, 13630), (0, 0, 270));
	CreateBlocks((9870, 18476, 13650), (0, 0, 270));
	CreateBlocks((9810, 18361, 13640), (0, 0, 90));
	CreateBlocks((9750, 18361, 13630), (0, 0, 90));
	CreateBlocks((9870, 18361, 13650), (0, 0, 90));
	CreateBlocks((10018, 18477, 13850), (0, 90, 0));
	CreateBlocks((10018, 18351, 13850), (0, 90, 0));
	CreateBlocks((9860, 18351, 13850), (0, 90, 0));
	CreateBlocks((9860, 18477, 13850), (0, 90, 0));
	CreateBlocks((9860, 18415, 13860), (90, 90, 90));
	CreateTurret((9870,18414,13895), (0, 180, 0));
}
HighRise()
{
	CreateRamps((557,5963,2956),(74,5918,3020));
	CreateRamps((273,6380,2824),(611,6417,2968));
	CreateBlocks((30,6881,3048),(0,0,0));
	CreateBlocks((30,6881,3108),(0,0,0));
	createFlag((-2308,6088,2780),(-2767,7044,3066));
	CreateGrids((-2600,7150,3225),(-2510,7360,3225));
	CreateWalls((-2480,7150,3215),(-2480,7360,3274));
	CreateWalls((-2480,7150,3310),(-2480,7360,3369));
	CreateWalls((-2510,7150,3255),(-2600,7150,3345));
	CreateWalls((-2510,7360,3255),(-2570,7360,3345));
	CreateGrids((-2810,7445,3225),(-2570,7470,3225));
	CreateBlocks((-2600,7400,3225),(0,90,0));
	CreateBlocks((-2650,7450,3245),(0,90,0));
	CreateIWall((-5444,783,209),(-5471,845,269));
	CreateAsc((-2399,6093,2780),(-2610,6093,3227),0,4);
	CreateAsc((-166,6296,2780),(-166,6296,3193),0,4);
}
HighRise2()
{
	level thread CreateKillIfBelow(-500);
	createFlag((-3605, 6859, 2830), (-5647, 10372, 5469));
	createFlag((-10531, 3506, 2331), (-3268, 5747, 2825));
	createFlag((-5163, 11174, 5475), (-5163, 12146, 5475));
	createFlag((-5163, 13469, 5475), (-5163, 9764, 5475));
	createFlag((-5163, 13469, 5475), (-5163, 9764, 5475));
	createFlag((-5944, 10354, 5667), (-7859, 6646, 2331));
	CreateWalls((-76, 6021, 3143.12), (-79, 6260, 3143));
	CreateWalls((-5274, 10193, 5666), (-5948, 10055, 5756));
	CreateWalls((-5948, 10055, 5666.0003), (-6030, 10407, 5756.0003));
	CreateWalls((-6030, 10407, 5666.0003), (-5585, 10499, 5756.0003));
	CreateWalls((-5585, 10499, 5666), (-5537, 10258, 5756.0003));
	CreateWalls((-5509, 10275, 5666), (-5286, 10320, 5756));
	CreateWalls((-5297, 10287, 5666), (-5286, 10221, 5756));
	CreateDoor("force",(-5578, 10295, 5666), (-5518, 10197, 5666.0003), (90, 0, -12), 3, 2, 15, 35);
}
Invasion()
{
	CreateRamps((-948,1783,163),(-614,1818,165));
	CreateRamps((-948,1783,163),(-995,1994,232));
	CreateRamps((-614,1818,165),(-574,1585,229));
	CreateRamps((-614,1818,165),(-630,2013,229));
	CreateRamps((-948,1783,163),(-895,1434,242));
	createFlag((-754,827,248),(-781,980,248),(0,-270,0));
	createFlag((-407,1069,256),(-414,906,248),(0,270,0));
	createFlag((385,-2452,322),(44,-2564,264),(0,270,0));
	createFlag((-877,-2801,256),(-864,-2943,252),(0,270,0));
	createFlag((-2154,-1749,304),(-2369,-1842,860),(0,270,0));
	CreateWalls((-971,3510,256),(-457,3606,256.0003));
	CreateWalls((-1143,2785,256),(-841,2860,248.0003));
	CreateWalls((-971,3510,316),(-457,3606,316.0003));
	CreateWalls((-1143,2785,316),(-841,2860,308.0003));
	CreateDoor("force",(-2055,-2040,860),(-2269,-2080,860),(90,100,0),10,2,55,125);
	CreateDoor("door",(-939,2842,248),(-738,2856,248),(90,100,0),8,2,40,75);
	CreateBlocks((-2053,-2044,860),(0,0,0));
	CreateBlocks((-2499,-2136,860),(0,0,0));
	CreateBlocks((-2053,-2044,920),(0,0,0));
	CreateBlocks((-2499,-2136,920),(0,0,0));
	CreateWalls((-614,-875,904),(-525,-1220,940));
	CreateWalls((-472,-1400,904),(-380,-1487,940));
	ScreateSecretFlag((-46,-562,564),(-1207,-1350,1065),(0,270,0));
	createFlag((-675,-1008,304),(-764,-1259,888),(0,270,0));
	CreateWalls((-1141,2825,294),(-1150,2992,335));
	CreateDoor("door",(-487,-1210,928),(-487,-1310,928),(90,-70.8487,90),6,1,45,75);
	CreateBlocks((-2055,-2042,971),(0,0,0));
	CreateBlocks((-1189,2779,280),(0,0,0));
	CreateBlocks((-1189,2779,320),(0,0,0));
	CreateBlocks((-1225,2779,320),(0,0,0));
	createFlag((-2378,-2110,279),(-5322,682,225));
	createFlag((-5355,2970,223),(-846,-1353,305));
	createFlag((-1656,-1403,970),(-1656,-1403,1094));
	CreateTWall((-4500,2700,150),(-846,-1353,305),700);
	CreateIWall((-5404,382,230),(-5106,814,290));
	CreateIWall((-5444,783,209),(-5471,845,269));
	CreateBlocks((-586,2775,294),(0,90,90));
	CreateBlocks((-988,3395,294),(0,90,90));
	CreateBlocks((-574,2542,295),(0,90,90));
}
Invasion2()
{
	createFlag((-495,452,255),(2351,4780,11));
	createFlag((-675,-1008,304),(-764,-1259,888),(0,270,0));
	CreateGrids((2390, 6449, 168), (2350, 5983, 168));
	CreateWalls((2480, 5999, 10), (2480, 6449, 179));
	CreateRamps((2449,6362,-5),(2449,6051,155));
	CreateBlocks((2448,6016,177),(0,90,0));
	CreateDoor("force",(2451,5964,40),(2400,5964,40),(90,100,0),5,1,15,75);
	CreateWalls((2335,5967,190), (2335, 6520, 300));
	CreateGrids((2482, 6452, 280), (2452, 6005, 280));
	CreateBlocks((2365,6362,184),(90,100,0));
	CreateBlocks((2365,6394,223),(90,100,0));
	CreateBlocks((2365,6445,233),(90,100,0));
	CreateBlocks((2311,5500,190),(0,0,90));
	/*part of orginal map*/ 
	CreateWalls((-614,-875,904),(-525,-1220,940));
	CreateWalls((-472,-1400,904),(-380,-1487,940));
	CreateDoor("door",(-487,-1210,928),(-487,-1310,928),(90,-70.8487,90),6,1,45,75);
	createFlag((2424,10308,10),(698,-707,311));
}
Quarry()
{
	CreatePlate((-1578,840,35),(-1608,840,35),(-1638,840,182),0,4) CreateAsc((-2402,1766,84),(-2402,1766,168),0,5);
	CreateWalls((-5785,-333,-6),(-5709,-419,13));
	CreateFire((-2390,1767,170));
	CreateAsc((-2402,1766,84),(-2402,1766,168),0,5);
	createFlag((-1431,1961,35),(-1431,2153,172));
	createFlag((-3757,-655,-183),(-2565,531,80));
	createFlag((-5338,449,-186),(-3995,2760,100));
	CreateWalls((-2370,2062,35),(-2370,2116,130));
	CreateDoor("force",(-2345,1972,64),(-2345,2020,64),(90,0,0),1,1,75,75);
	CreateDoor("force",(-1953,1961,64),(-2000,1961,64),(90,0,90),1,1,75,75);
	CreateDoor("force",(-1710,1551,64),(-1630,1551,64),(90,0,90),4,1,100,75);
	CreateDoor("force",(-1871,1929,64),(-1871,1823,64),(90,0,0),4,1,100,75);
	CreateWalls((-2082,1687,84),(-2265,1687,90));
	CreateDoor("force",(-1839,1395,64),(-1839,1243,64),(90,0,0),6,1,75,75);
	CreateDoor("force",(-1839,889,64),(-1839,1040,64),(90,0,0),4,1,75,75);
}
Quarry2()
{
	createFlag((-3702, -51, -119), (-3493, 23, 100), (0,-40,0));
	createFlag((-3210, -246, 243), (-3094, -299, 326), (0,-40,0));
	createFlag((-2922, -404, 456), (-2767, -490, 518), (0,-40,0));
	createFlag((-2464, -660, 351), (-2368, -636, -30), (0,10,0));
	createFlag((-2369, -718, 534), (-2489, -641, 441), (0,0,0));
	CreateWalls((-1905, -1480, 760), (-1839, -1351, 760.0003));
	CreateWalls((-1905, -1480, 820), (-1839, -1351, 820.0003));
	CreateWalls((-1905, -1480, 880), (-1839, -1351, 880.0003));
	CreateBlocks((-2047, -1232, 642), (0, 90, 0));
	CreateBlocks((-2023, -1232, 672), (0, 90, 0));
	CreateBlocks((-1999, -1232, 707), (0, 90, 0));
	createFlag((-2665, -1545, 88), (-2604, -1523, 552), (0,0,0));
	CreateRamps((-2462, -1497, 552), (-2243, -1297, 632));
	CreateBlocks((-5817, -319, -88), (0, 0, 0));
	CreateBlocks((-5817, -289, -108), (0, 0, 0));
	CreateBlocks((-1929, -1039, 770), (0, 0, 0));
	CreateBlocks((-1751, -823, 820), (0, 0, 0));
	CreateBlocks((-1969, -1419, 761), (0, 0, 0));
	CreateBlocks((-1980, -1419, 781), (0, 0, 0));
	CreateAsc((-4593, 363, -150), (-4504, 376, 90), 0, 4);
	CreateAsc((-5511, 1426, 100), (-5618, 1476, 187), 0, 3);
	CreateAsc((-3605, 684, 0), (-3582, 699, 139), 0, 4);
	createFlag((-4953, 1043, 120), (-5440, 2264, 220), 0);
	createFlag((-5788, 1201, 310), (-5581, 1122, 568), 0);
	CreateAsc((-4795, 1110, 172), (-4795, 1719, 159), 0, 5);
	ScreateSecretFlag((-1454, -601, 723), (-3333, 1722, 392), 0);
}
Rundown()
{
	level thread CreateKillIfBelow(-300);
	CreateDoor("door",(360,-1462,202),(300,-1342,202),(90,50,0),3,2,10,75);
	CreateDoor("door",(460,-1420,206),(400,-1300,206),(90,50,0),3,2,10,75);
	CreateDoor("door",(30,-1630,186),(-30,-1510,186),(90,50,0),4,2,15,75);
	CreateDoor("door",(-280,-1482,186),(-220,-1602,186),(90,50,0),4,2,15,75);
	CreateBlocks((385,-1660,40),(0,120,90));
	CreateRamps((-597,-280,212),(-332,-522,180));
	CreateRamps((726,-389,142),(560,-373,13));
	CreateRamps((2250,-1155,306),(1905,-876,200));
	CreateRamps((850,-3125,312),(535,-3125,189));
	CreateRamps((1775,450,144),(1775,735,-5));
	CreateRamps((970,-3284,262),(969,-3145,309));
	CreateRamps((949,104,192),(966,-312,163));
	CreateRamps((730,-887,157),(748,-433,145));
	createFlag((650.801,3224.55,61.1594),(527.039,3546.58,38.7205),0);
	createFlag((739.624,3431.01,61.6672),(529.638,3137.63,62.1063),0);
	CreateAsc((-1387.79,227.345,317.767),(-1036.64,-122.391,254.072),0,5);
	CreateAsc((1522,-582,350),(947.224,132.054,205.937),0,5);
	CreateAsc((722.619,-2109.78,283.888),(-194.991,-1773.13,290.157),0,5);
	CreateFire((745,-1121,244));
}
Rundown2()
{
	createFlag((3203, -2530, 200), (901, -1493, 110));
	createFlag((320, -536, 31), (2912, -1348, 171));
	createFlag((3035, -68, -117), (901, -1493, 110));
	createFlag((3339, -2250, 200), (3120, -1100, 355));
	CreateRamps((970, -3284, 262), (969, -3145, 309));
	CreateRamps((949, 104, 192), (966, -312, 163));
	CreateRamps((730, -887, 157), (748, -433, 145));
	CreateWalls((965, 377, 214), (725, 384, 274));
	CreateFire((948, -71, 206));
	CreateAsc((1522,-582,350), (947,132,205), 0, 5);
	CreateAsc((1611, -924, 165), (1648, -656, 355), 0, 3);
	ScreateSecretFlag((3443, -2396, 203), (-519, -2240, 51));
	ScreateSecretFlag((-407, -2417, 69), (-292, -2525, 95));
	ScreateSecretFlag((-378, -2513, 88), (3097, -2358, 205));
	ScreateSecretFlag((3443, -2396, 203), (-519, -2240, 51));
	CreateTWall((1306, 2273, 184), (-159, -368, 167), 50);
	CreateFire((-200, -400, 187));
	/*CreateFire((-249, -411, 187));*/ 
	/*CreateFire((-179, -439, 187));*/ 
	level thread CreateKillIfBelow(-250);
	CreateWalls((3214, -2024, 220), (2972, -2249, 250));
	CreateWalls((3410, -1882, 215), (3610, -1712, 305));
	CreateDoor("force",(3248, -1996, 225), (3340, -1900, 225), (0, 305, 0), 4, 1, 50, 90);
	CreateGrids((3054, -1261, 320), (3210, -1000, 320));
	CreateTWall((3720, -1450, 532), (901, -1493, 110), 100);
	CreateIWall((2880, -1206, 156), (3390, -1329, 246));
	CreateTWall((4800, 354, 0), (901, -1493, 110), 900);
}
Rundown3()
{
	level thread CreateKillIfBelow(-300);
	createFlag((1805,-2181,204),(1778,-73,-123),(0,0,0));
	createFlag((-760,-631,16),(2724,286,-127),(0,0,0));
	createFlag((399,-80,16),(3089,-475,-127),(0,0,0));
	createFlag((1413,-94,16),(4716,283,-127),(0,0,0));
	CreateRamps((3109,-179,-120),(3339,-179,-60));
	CreateRamps((3339,-179,-60),(3339,9,0));
	CreateRamps((3339,9,0),(3109,9,60));
	CreateRamps((3109,9,60),(3109,-179,120));
	CreateRamps((3109,-179,120),(3339,-179,180));
	CreateRamps((3339,-179,180),(3339,9,240));
	CreateRamps((3339,9,240),(3109,9,300));
	CreateRamps((3109,9,300),(3109,-179,360));
	CreateRamps((3109,-179,360),(3339,-179,420));
	CreateRamps((3339,-179,420),(3339,9,480));
	CreateRamps((3339,9,480),(3109,9,540));
	CreateRamps((3109,9,540),(3109,-179,600));
	CreateRamps((3109,-179,600),(3339,-179,660));
	CreateRamps((3339,-179,660),(3339,9,720));
	CreateRamps((3339,9,720),(3109,9,780));
	CreateRamps((3109,9,780),(3109,-179,840));
	CreateRamps((3109,-179,840),(3339,-179,900));
	CreateRamps((3339,-179,900),(3339,9,960));
	CreateRamps((3339,9,960),(3109,9,1020));
	CreateRamps((3109,9,1020),(3109,-179,1080));
	CreateRamps((3109,-179,1080),(3339,-179,1140));
	CreateRamps((3339,-179,1140),(3339,9,1200));
	CreateRamps((3339,9,1200),(3109,9,1260));
	CreateGrids((3109,180,1260),(2939,-206,1260),(0,0,0));
}
Rust()
{
	level thread CreateKillIfBelow(-3500);
	CreateCircle((512,378,-100),(1421,1100,-100),(633,1147,332),(-242,997,400), (470,302,700),(1240,254,-100),0,5);
	CreateWalls((921,834,18),(870,834,118));
	CreateWalls((1036,829,90),(1107,829,70));
	CreateWalls((779,791,25),(779,682,105));
	CreateWalls((1199,829,2),(1126,829,105));
	CreateWalls((1199,829,6),(1199,682,35));
	CreateWalls((1199,829,75),(1199,682,105));
	CreateWalls((1108,682,6),(779,682,35));
	CreateWalls((1108,682,75),(779,682,105));
	CreateRamps((914,707,-22),(795,707,-22));
	CreateDoor("force",(1071,684,24),(1149,682,24),(90,90,0),1,2,50,75);
	CreateRamps((1160,197,-10),(1153,678,-25));
	CreateHiddenBlocks((559,949,156),(90,90,0));
	CreateRamps((1459,197,-10),(1501,777,-145));
	CreateRamps((1467,1026,-132),(1406,1212,-113));
	CreateRamps((1031,1603,-109),(1161,1445,-113));
	createFlag((809,784,10),(309,587,-157),(0,0,0));
	createFlag((1327,48,-176),(1613,868,-96),(0,0,0));
	CreateWalls((505,-101,-218),(505,-225,-184));
	CreateDoor("force",(770,-98,-186),(770,-15,-186),(90,0,0),4,2,50,125);
	CreateFire((479,-106,-163));
	//CreateWalls((-296.11,1034.35,-132.875),(-296.11,806.35,-90.200));
	//CreateWalls((-305.11,1034.35,-132.875),(-412.11,1034.35,-90.200));
	//CreateWalls((-305.11,806.35,-132.875),(-476.11,806.35,-90.200));
	//CreateWalls((-296.11,1034.35,-50.200),(-296.11,806.35,-20.200));
	//CreateWalls((-305.11,1034.35,-90.200),(-412.11,1034.35,-20.200));
	//CreateWalls((-305.11,806.35,-90.200),(-476.11,806.35,-20.200));
	//CreateWalls((-305.11,806.35,-30.200),(-476.11,806.35,-20.200));
	//CreateWalls((-296.11,1034.35,-30.200),(-296.11,806.35,-20.200));
	//CreateDoor("force",(-402.11,1034.35,-90.200),(-460.11,1034.35,-90.200), (180,0,90),3,1,50,75);
	//CreateRamps((-455.464,1150.19,-235.245),(-460.11,1050.35,-151.200));
	//CreateRamps((-476.11,836.35,-132.875),(-305.11,836.35,-20.200));
	//CreateGrids((-310.11,1034.35,-20.200),(-476.11,881.35,-20.200));
	CreateHiddenBlocks((753,707,145),(90,0,0));
	CreateHiddenBlocks((735,765,145),(90,0,0));
	CreateHiddenBlocks((1044,888,76),(90,0,0));
//	CreateWalls((80,1670,-130),(-150,1670,30));
	//CreateWalls((-170,1400,-40),(-170,1460,30));
	//CreateWalls((-170,1400,-130),(-170,1460,-90));
	//CreateWalls((-170,1400,-130),(80,1400,-90));
	//CreateWalls((-170,1400,-40),(80,1400,30));
	//CreateWalls((90,1640,-130),(90,1430,-90));
	//CreateWalls((90,1640,-40),(90,1430,30));
	//createFlag((-173,1639,-130),(309,587,-157));
	//CreateDoor("force",(-164,1547,-90),(-164,1506,-90),(90,0,0),1,2,50,125);
}
Rust2()
{
	level thread CreateKillIfBelow(-3500);
	CreateAsc((457,125,-265), (457,125,332), 0, 5);
	createFlag((520,310,362), (1745, 1650, -130), 0);
	CreateGrids((420,210,332), (620,410,332), 0);
	CreateCircle((512,378,-106), (1421,1100,100), (633,1147,332), (-242,997,400), (470,302,700), (1240,254,-58), 0, 5);
	CreateBlocks((773, 1080, 258), (0, 90, 0));
	CreateRamps((745, 1570, 383), (745, 1690, 273));
	CreateDoor("force",(565, 1540, 330), (653, 1540, 330), (90, 90, 0), 3, 1, 55, 100);
	CreateGrids((773, 1135, 258), (533, 1795, 258), (0, 0, 0));
	CreateGrids((695, 1795, 378), (533, 1540, 378), (0, 0, 0));
	CreateWalls((533, 1795, 278), (773, 1795, 438));
	CreateWalls((790, 1795, 278), (790, 1540, 438));
	CreateWalls ((515, 1540, 278), (515, 1795, 438));
	CreateWalls((773, 1540, 278), (715, 1540, 378));
	CreateWalls((590, 1540, 278), (533, 1540, 378));
	CreateWalls((773, 1540, 398), (533, 1540, 428));
	/*CreateWalls((773, 1540, 458), (740, 1540, 498));*/ 
	/*CreateWalls((566, 1540, 458), (533, 1540, 498));*/ 
	ScreateSecretFlag((285, 1926, -214), (1745, 1650, -130), (0,180,0), 25);
}
Rust3()
{
	level thread CreateKillIfBelow(-3500);
	CreateWalls((505,-101,-218),(505,-225,-184));
	CreateDoor("force",(770,-98,-186),(770,-15,-186),(90,0,0),4,2,50,125);
	CreateFire((479,-106,-163));
	CreateBlocks((978,847,18),(0,0,0));
	CreateWalls ((378.851,1855.13,-214.265),(379.599,2011.6,-201.867));
	CreateWalls((379.599,2011.6,-201.867),(-437.515,2122.24,-190.13));
	CreateWalls((- 437.515,2122.24,-190.13),(-426.486,1883.13,-177.272));
	CreateWalls((378.851,1855.13,-154.265),(379.599,2011.6,-141.867));
	CreateWalls ((379.599,2011.6,-141.867),(-437.515,2122.24,-130.13));
	CreateWalls((-437.515,2122.24,-130.13),(-426.486,1883.13,-117.272));
	CreateWalls((- 163.853,1883.13,-166.048),(-144.698,1960.2,-200.263));
	CreateWalls((-163.853,1883.13,-106.048),(-144.698,1960.2,-140.263));
	CreateDoor("force",(-178,1918,-183),(-178,2019,-209),(90,0,0),3,2,45,75);
	CreateRamps((-437,1900,- 260),(-200,1900,-100));
	CreateGrids((-437,1950,-100),(-200,2100,-100),(0,0,0));
	CreateRamps((-437,1900,-145),(-200,1900,15));
	CreateGrids((- 437,1950,15),(-200,2100,15),(0,0,0));
	CreateWalls((-179.968,1883.13,-79.223),(-177.373,2088.21,-85.375));
	CreateWalls((-207.851,2104.71,- 85.375),(-403.362,2108.31,-85.376));
	CreateWalls((-434.046,2112.2,-85.375),(-434.317,1883.13,-103.305));
	CreateWalls((-179.968,1883.13,-19.223), (-177.373,2088.21,-25.375));
	CreateWalls((-207.851,2104.71,-25.375),(-403.362,2108.31,-25.376));
	CreateWalls((-434.046,2112.2,-25.375),(- 434.317,1883.13,-43.305));
	CreateWalls((-179.968,1883.13,41.223),(-177.373,2088.21,35.375));
	CreateWalls((-207.851,2104.71,35.375),(- 403.362,2108.31,35.376));
	CreateWalls((-434.046,2112.2,35.375),(-434.317,1883.13,17.305));
	CreateWalls((-179.968,1883.13,40.223),(- 177.373,2088.21,35.375));
	CreateWalls((-207.851,2104.71,95.375),(-403.362,2108.31,95.376));
	CreateWalls((-434.046,2112.2,95.375),(- 434.317,1883.13,77.305));
	CreateRamps((-437,1900,-30),(-200,1900,130));
	CreateGrids((-437,1950,130),(-200,2100,130),(0,0,0));
	CreateWalls((- 207.851,2104.71,155.375),(-403.362,2108.31,155.376));
	CreateWalls((-434.046,2112.2,155.375),(-434.317,1883.13,137.305));
	CreateWalls((- 179.968,1883.13,171.223),(-177.373,2088.21,265.375)) CreateWalls((-207.851,2104.71,215.375),(-403.362,2108.31,215.376));
	CreateWalls((- 434.046,2112.2,215.375),(-434.317,1883.13,197.305));
	//CreateWalls((-207.046,2107.2,222.375),(-403.317,2111.13,222.305));
	createFlag ((280,1771,-228),(172,1937 ,-208),(0,180,0));
	createFlag((285,1926 ,-214),(1745,1650 ,-130),(0,180,0),25);
	
	CreateWalls((- 207.851,2104.71,222.375),(-403.362,2108.31,222.376));

	//CreateWalls((-207.046,2107.2,222.375),(-403.317,2111.13,222.305));
}
SubBase()
{
	CreateWalls((-817,-1848,260),(-817,-1943,400));
	CreateDoor("force",(1069, -1138, 294), (1100, -1078, 294), (90, 0, 0), 2, 2, 50, 50);
	CreateDoor("force",(-859, -1249, 278), (-839, -1319, 278), (90, 0, 0), 2, 2, 50, 50);
	CreateDoor("force",(-1428, -1152, 278), (-1498, -1182, 278), (90, 90, 0), 2, 2, 50, 50);
	CreateDoor("force",(-435, -50, 111), (-380, -50, 111), (90, 90, 0), 2, 2, 50, 50);
	CreateDoor("force",(-643, -50, 111), (-708, -50, 111), (90, 90, 0), 2, 2, 50, 50);
	CreateDoor("force",(1178, -438, 102), (1248, -438, 102), (90, 90, 0), 2, 2, 50, 50);
	CreateDoor("force",(1112, -90, 246), (1112, -160, 246), (90, 0, 0), 2, 2, 50, 50);
	CreateBlocks((-1506,800,123),(0,0,45));
	createFlag((1691,-2505,0),(1691,-2605,0),(0,-40,0));
	createFlag((1199,-2999,153),(-355,-3991,0));
	createFlag((-351,-6395,60),(-123,164,610));
	CreateBlocks((1194,-4513,169),(0,0,0));
	CreateBlocks((1450,-5171,24),(0,0,0));
	CreatePlate((1594,-3722,11),(1654,-3782,11),(1350,-3975,503),0,4) CreateAsc((1594,-3722,11),(1333,-3975,503),0,5);
	CreateTWall((2393,812,34),(-2068,-7110,309),75);
	createFlag((-2197,-7032,217),(-355,-3991,0));
	CreateCluster(18,(1641,-3200,251),180);
	CreateCluster(10,(-367,-5033,210),150);
	CreateAsc((1177,-3763,110),(1177,-3763,520),0,4);
	ScreateSecretFlag((105,925,200),(1315,-2545,160));
	CreateDoor("force",(-533,-1777,88),(-682,-1777,88),(90,180,90),7,1,75,75);
	CreateDoor("force",(90,-945,128),(160,-945,128),(90,180,90),6,1,75,75);
	CreateBlocks((-490,-1919,68),(90,0,0));
	CreateBlocks((53,-971,147),(90,0,0));
	CreateBlocks((269,-971,147),(90,0,0));
	createFlag((-208,-1280,59),(1691,-2605,11),(0,-40,0));
	CreateBlocks((-785,-1546,88),(0,0,90));
	CreateBlocks((-625,-1391,88),(0,90,90));
	createFlag((-788,-1399,59),(-292,-2350,60));
	createFlag((280,-1755,59),(-292,-2350,60));
	CreateBlocks((138,-1758,88),(0,90,90));
	CreateBlocks((285,-1596,88),(0,0,90));
}
SubBase2()
{
	CreateTurret((1630,-4681,32), (0, 90, 0));
	CreateDoor("force",(1750, -4516, 5), (1630, -4516, 5), (90, 180, 90), 4, 2, 20, 80);
	CreateDoor("force",(1767, -4840, 5), (1767, -4935, 5), (90, 180, 90), 1, 2, 5, 75);
	createFlag((1691, -2393, 0), (1638, -2655, 0), (0, 270, 0));
	createFlag((-581, -596, 120), (1638, -2655, 0), (0, 270, 0));
	createFlag((1481, -5140, 110), (1306, -4110, 300), (0, 90, 0));
	createFlag((1780, -5140, 110), (-1172, -1634, 215), (0, 90, 0));
	CreateWalls((1780, -4516, 0), (1710, -4516, 100));
	CreateWalls((1480, -4516, 0), (1550, -4516, 100));
	CreateWalls((1480, -4490, 135), (1780, -4490, 80));
	CreateWalls((1450, -5160, 135), (1450, -4490, 80));
	CreateWalls((1805, -5175, 135), (1455, -5175, 80));
	CreateWalls((1810, -4490, 135), (1810, -5175, 80));
	CreateWalls((1523, -4911, 100), (1736, -4911, 140));
	CreateBlocks((1523, -4911, 150), (90, -90, 0));
	CreateBlocks((1736, -4911, 150), (90, -90, 0));
	CreateRamps((1720, -4533, 103), (1720, -4738, -5));
	CreateRamps((1780, -4516, 100), (1480, -4516, 100));
	CreateRamps((1480, -4516, 100), (1480, -5160, 100));
	CreateRamps((1480, -5160, 100), (1780, -5160, 100));
	CreateRamps((1780, -5160, 100), (1780, -4500, 100));
	CreateGrids((1516, -4911, 100), (1744, -5119, 100), (0, 0, 0));
	CreateBlocks((1324, -4063, 175), (90, -90, 0));
	CreateBlocks((1054, -4063, 175), (90, -90, 0));
	CreateWalls((1780, -3000, 0), (1690, -3000, 70));
	CreateWalls((1570, -3000, 0), (1480, -3000, 70));
	CreateWalls((1680, -3130, 0), (1565, -3130, 70));
	CreateBlocks((1630, -4672, 2), (90, 90, 0));
	CreateTWall((-207, -1267, 88), (-2068, -7110, 309), 35);
	CreateTWall((2259, 1571, 82), (-482, 2184, 218), 35);
}

Terminal()
{
	CreateAsc((759,3722,160),(759,3722,402),0,5);
	CreateWalls((1386,7583,215),(1386,7759,305));
	CreateWalls((1386,7935,215),(1386,8111,305));
	CreateWalls((1386,7583,333),(1496,7583,363));
	CreateIWall((1300,7583,363),(1290,7583,393));
	CreateIWall((1210,7583,393),(1180,7583,423));
	CreateRamps((1386,7628,320),(1620,7628,206));
	CreateGrids((1395,7684,315),(1725,8111,315));
	CreateWalls((3375,2715,215),(3765,3210,214));
	CreateIWall((4425,3580,380),(4425,3230,440));
	/*CreateIWall((4045,3615,382),(3650,3615,412));*/ 
	/*CreateIWall((2960,2800,379),(3250,2800,409));*/ 
	CreateRamps((3620,2415,369),(4015,2705,192));
	CreateGrids((4380,2330,360),(4380,2980,360),(0,0,0));
	CreateBlocks((1635,2470,121),(0,0,0));
	createFlag((2170,7236,202),(601,3834,403),(0,0,0));
	createFlag((3153,2872,252),(601,3834,403),(0,90,0));
	CreateIWall((3221,3095,200),(3221,2972,232));
	CreateTWall((3755,2304,200),(3697,4786,210),20);
	CreateIWall((3476,4862,200),(3476,4944,250));
	createFlag((3688,4938,200),(601,3834,403));
	createFlag((407,6949,208),(601,3834,403));
	createFlag((722,7551,440),(435,7225,242));
	ScreateSecretFlag((1050,7498,203),(466,4854,577));
	ScreateSecretFlag((673,5441,520),(2855,3471,252));
	CreateDoor("force",(1386,7960,255),(1386,7845,255),(90,90,90),4,1,60,100);
	CreateDoor("door",(3860,3305,232),(3860,3485,232),(90,0,0),6,2,60,75);
	createFlag((1071,7251,192),(519,7834,206));
	createFlag((2859,4529,192),(3045,4480,250),(0,0,0));
	createFlag((2975,4080,192),(2882,4289,55),(0,180,0));
	createFlag((4333,3486,359),(3024,2880,252),(0,0,0));
	createFlag((877,8076,342),(1612,7081,192));
	createFlag((1673,7970,200),(2148,7922,223),(0,0,0));
}
Terminal2()
{
	createFlag((-13559, 15969, 50), (624, 2476, 100));
	createFlag((-262, 4863, 193), (-13509, 11535, 48.1253));
	CreateWalls((-13273, 13802, 40.125), (-13273, 14344, 141));
	CreateWalls((-13303, 14338, 40.125), (-13705, 14346, 141));
	CreateWalls((-13736, 14348, 40.125), (-13743, 13817, 141));
	CreateWalls((-13303, 13798, 40.125), (-13390, 13801, 141));
	CreateWalls((-13712, 13809, 40.125), (-13665, 13809, 141));
	CreateRamps((-13295, 13811, 99.07930), (-13293, 14310, 91.2106));
	CreateGrids((-13445, 14002, 253), (-13611, 14105, 251), (0, 0, 0));
	CreateRamps((-13458, 14311, 40.125), (-13331, 14309, 87.1247));
	CreateRamps((-13529, 14320, 130), (-13527, 14123, 251));
	CreateRamps((-13715, 14324, 95.8787), (-13719, 13825, 99.6023));
	CreateRamps((-13572, 14313, 40.125), (-13676, 14319, 93.7747));
	CreateDoor("door",(-13432, 13801, 48.1271), (-13539, 13805, 48.1268), (90, 90, 0), 9, 2, 15, 100);
	CreateWalls((-13433, 14009, 268.125), (-13622, 14012, 269));
	CreateTurret((-13527,14041,308),(0,-90,0));
	CreateModel((-13274, 14374, -1500),(0,15,0),"com_tower_crane");
	CreateModel((-13734, 14374, -1500),(0,-15,0),"com_tower_crane");
}
CreateModel(pos, angle, model)
{
	PrecacheModel(model);
	block = spawn("script_model", pos );
	block setModel(model);
	block.angles = angle;
	block Solid();
	wait 0.01;
}
Terminal3()
{
	createFlag((4333,3486,359),(3024,2880,252),(0,0,0));
	createFlag((1497, 6395, 420), (1454, 6511, 464), (0, 0, 0));
	createFlag((532, 6516, 464), (359, 4624, 306), (0, 0, 0));
	createFlag((2859,4529,192),(3045,4480,250),(0,0,0));
	createFlag((2975,4080,192),(2882,4289,55),(0,180,0));
	CreateWalls((3375,2715,215),(3765,3210,214));
	CreateDoor("door",(3860,3305,232),(3860,3485,232),(90,0,0),6,2,60,75);
	CreateRamps((3620,2415,369),(4015,2705,192));
	CreateGrids((4380,2330,360),(4380,2980,360),(0,0,0));
	createFlag((3153,2872,252),(601,3834,403),(0,90,0));
	CreateIWall((3221,3095,200),(3221,2972,232));
	CreateTWall((3755,2304,200),(3697,4786,210),20);
	CreateIWall((3476,4862,200),(3476,4944,250));
	createFlag((3688,4938,200),(601,3834,403));
	createFlag((407,6949,208),(601,3834,403));
	createFlag((722,7551,440),(435,7225,242));
	ScreateSecretFlag((1050,7498,203),(466,4854,577));
	ScreateSecretFlag((673,5441,520),(2855,3471,252));
	CreateAsc((759,3722,160),(759,3722,402),0,5);
	CreateRamps((923, 5650, 343), (646, 5650, 192));
	CreateBlocks((876, 5604, 392), (0, 0, 0));
	CreateBlocks((876, 5694, 392), (0, 0, 0));
	CreateRamps((923, 5551, 343), (532, 5551, 429));
	CreateRamps((528, 6385, 423), (1511, 6385, 423));
	CreateWalls((473, 6488, 500), (473, 6899, 501));
	CreateWalls((1517, 6899, 500), (473, 6899, 501));
	CreateWalls((1517, 6488, 500), (1517, 6899, 501));
	CreateDoor("door",(927, 5604, 398), (917, 5650, 398), (90,0, 0), 1, 1, 25, 75);
	CreateTurret((1008, 6486, 530), (0, 270, 0));
	CreateBlocks((600, 6089, 434), (0, 90, 0));
	CreateBlocks((570, 6089, 434), (0, 90, 0));
	CreateBlocks((540, 6089, 434), (0, 90, 0));
	CreateDoor("door",(592, 6052, 480), (479, 6013, 480), (90,90, 0), 2, 1, 25, 75);
	CreateBlocks((539, 6013, 480), (90, 90, 0));
	CreateIBlock((2959,2830,320),(0,0,0));
	CreateAsc((4562,3561,190),(4562,3561,350),0,5);
}
Underpass()
{
	CreateDoor("door",(-339,3105,264),(-339,3162,264),(90,0,0),4,2,50,100);
	CreateDoor("door",(-427,2951,392),(-480,2951,392),(90,0,90),3,2,50,100);
	CreateBlocks((679,1747,493),(0,0,0));
	CreateBlocks((729,1747,493),(0,0,0));
	CreateBlocks((769,1747,493),(0,0,0));
	CreateBlocks((957,297,118),(0,0,0));
	CreateDoor("door",(1254,-696,512),(1342,-696,512),(90,0,90),4,2,50,100);
	CreateDoor("door",(391,-78,320),(391,-128,320),(90,0,0),4,2,50,100);
	CreateWalls((-1201,617,435),(-1089,823,465));
	createFlag((618,255,380),(-1100,2666,494));
	createFlag((-3253,552,423),(1178,2280,253));
	createFlag((3631,347,299),(3825,1111,395));
	createFlag((4608,671,656),(540,1479,552));
	ScreateSecretFlag((3389,3394,395),(531,-1536,1500));
	createFlag((-2886,-392,2195),(-464,2078,369));
	CreateAsc((636,2529,507),(621,2529,699),0,5);
	CreateAsc((-1281,2000,415),(-1281,2000,675),0,5);
	CreateTurret((-1210,2100,620),(0,-90,0));
	CreateBlocks((-1110,708,430),(0,0,0));
	CreateBlocks((-510,571,565),(0,90,0));
	CreateRamps((4388,1903,600),(4508,2528,450));
	CreateWalls((-326,1229,363),(-524,1229,419));
	createFlag((-1616,2660,616),(-1601,1866,2009));
	CreateRamps((-1223,2286,580),(-1050,2286,580));
	ScreateSecretFlag((1601,1079,345),(-1130,1142,616));
	CreateBlocks((153,-146,360),(90,0,0));
	CreateDoor("force",(-115,-201,348),(-205,-231,348),(90,90,0),4,1,70,110);
	CreateDoor("force",(-105,408,224),(-190,445,224),(90,90,0),4,1,70,110);
	createFlag((127,336,190),(-1100,2666,494));
	CreateFire((-83,-156,704));
	CreateFire((-83,-17,738));
	CreateFire((-276,-72,717));
	CreateFire((-160,-95,639));
	createFlag((1158,2048,380),(4222,2965,504));
	CreateGrids((-1075,1109,590),(-1200,1187,590),0);
	CreateGrids((-1079,1200,590),(-1090,1600,590),0);
	CreateWalls((-1767,1644,2063),(-1693,1582,2090));
}
Underpass2()
{
	CreateWalls((2447, 1688, 320), (2843, 1688, 500));
	CreateWalls((2993, 855, 290), (2591, 855, 420));
	CreateDoor("force",(2591, 885, 332), (2520, 885, 332), (90, 90, 0), 4, 1, 75, 75);
	CreateRamps((2466, 1633, 270), (2466, 1357, 449));
}
Underpass3()
{
	createFlag((-415, 3185, 392), (-1630, 3565, 1035), (0, 180, 0));
	CreateBlocks((1110, 1105, 632), (90, 0, 0));
	CreateBlocks((-2740, 3145, 1100), (90, 0, 0));
	CreateBlocks((2444, 1737, 465), (90, 0, 0));
	CreateWalls((-2730, 3453, 1030), (-2730, 3155, 1150));
	CreateWalls((-2730, 3155, 1030), (-3330, 3155, 1180));
	CreateWalls((-3330, 3155, 1030), (-3330, 3890, 1180));
	CreateWalls((-3330, 3890, 1030), (-2730, 3890, 1180));
	CreateWalls((-2730, 3890, 1030), (-2730, 3592, 1150));
	CreateWalls((-2730, 3890, 1150), (-2730, 3155, 1180));
	CreateDoor("door",(-2730, 3400, 1052), (-2730, 3522.5, 1052), (90, 180, 0), 4, 2, 20, 75);
	CreateRamps((-3285, 3190, 1125), (-3285, 3353, 1030));
	CreateRamps((-3285, 3855, 1125), (-3285, 3692, 1030));
	CreateGrids((-2770, 3190, 1120), (-3230, 3190, 1120), (0, 0, 0));
	CreateGrids((-2770, 3855, 1120), (-3230, 3855, 1120), (0, 0, 0));
	CreateGrids((-2770, 3220, 1120), (-2770, 3825, 1120), (0, 0, 0));
}
Wasteland()
{
	CreateWalls((1050,1325,-100),(315,1325,110));
	CreateWalls((315,1090,-100),(1050,1090,110));
	CreateWalls((1050,1300,-20),(1050,1100,10));
	CreateWalls((1050,1300,30),(1050,1100,110));
	CreateDoor("door",(400,1095,-70),(400,1240,-70),(90,0,0),7,1,50,100);
	createFlag((585,-2002,34),(100,900,-60),0);
	ScreateSecretFlag((2665,-3867,106),(-3531,1210,95));
	ScreateSecretFlag((-3813,1177,95),(141,-568,169));
	ScreateSecretFlag((252,-781,169),(1721,-1027,169));
	createFlag((1704,-598,167),(141,-568,169));
	CreateDoor("force",(1344, -778, -33), (1344, -898, -33), (90, 0, 0), 5, 2, 75, 75);
	CreateDoor("force",(684, -695, -16), (684, -825, -16), (90, 0, 0), 5, 2, 75, 75);
	CreateDoor("force",(890, -120, -12), (760, -120, -12), (90, 90, 0), 5, 2, 75, 125);
	CreateDoor("force",(958, -1072, -36), (958, -972, -36), (90, 0, 0), 3, 2, 50, 50);
	CreateDoor("force",(1057, -648, -36), (997, -748, -36), (90, -30, 0), 3, 2, 50, 50);
	createFlag((26,-1715,22),(3910,-3391,105),0);
}
Wasteland2()
{
	createFlag((11066, 10143, 1309), (225, 214, 240), (0, 300, 0));
	level thread CreateKillIfBelow(-3480);
	createFlag((10374, 12649, 320), (11090, 14391, 1338), (0, 300, 0));
	createFlag((9079, 12618, 188), (11090, 14391, 1338), (0, 300, 0));
	createFlag((12089, 13274, 364), (11090, 14391, 1338), (0, 300, 0));
	CreateDoor("force",(11214, 12551, 1338), (11050, 12580, 1338), (90, 0, 90), 6, 2, 15, 75);
	createFlag((218, -618, -26), (11288, 14676, 1298), (0, 300, 0));
	createFlag((-2336, -1348, 32), (11046, 14518, 1298), (0, 270, 0));
	createFlag((-1021, 1263, 77), (11232, 14122, 1298), (0, 270, 0));
	createFlag((2836, 978, -124), (10917, 13826, 1298), (0, 270, 0));
	createFlag((2348, -1855, -13), (11046, 13421, 1298), (0, 270, 0));
	CreateWalls((10798, 12581, 1298), (10955, 12581, 1340));
	CreateWalls((11167, 12581, 1298), (11379, 12581, 1340));
	CreateRamps((10850, 11700, 1298), (10850, 12300, 1448));
	CreateRamps((11300, 11700, 1298), (11300, 12300, 1448));
	CreateGrids((10798, 12581, 1450), (11379, 12300, 1450), (0, 0, 0));
}
Wasteland3()
{
	createFlag((4696, -2739, 54), (276, -3811, 97), 0);
	createFlag((-326, -2367, 46), (4200, -3100, 45), 0);
	CreateWalls((4800, -3000, 39), (4950, -3000, 160));
	CreateWalls((4950, -3000, 39), (4950, -3400, 160));
	CreateWalls((4950, -3400, 39), (4800, -3400, 160));
	CreateWalls((4800, -3400, 39), (4800, -3275, 180));
	CreateWalls((4800, -3125, 39), (4800, -3000, 160));
	CreateDoor("door",(4800, -3300, 85), (4800, -3200, 85), (90, 180, 0), 4, 1, 50, 75);
	CreateAsc((4845, -3030, 10), (4845, -3030, 160), 0, 4);
	CreateGrids((4800, -3100, 150), (4925, -3400, 150), 0);
	CreateWalls((1050, 1325, -100), (-100, 1325, 70));
	CreateWalls((-100, 1090, -100), (1050, 1090, 70));
	CreateWalls((1050, 1300, -20), (1050, 1100, 10));
	CreateWalls((1050, 1300, 30), (1050, 1100, 110));
	CreateAsc((-2340, -1461, -20), (-2340, -1476, 250), 0, 7);
	CreateDoor("door",(400, 1095, -70), (400, 1240, -70), (90, 0, 0), 7, 1, 50, 100);
	CreateWalls((100, 1120, -90), (100, 1300, -35));
	CreateBlocks((70, 1150, -85), (0, 0, 0));
	CreateBlocks((145, 1150, -85), (0, 0, 0));
	CreateTurret((401, 1096, 89), 0);
	CreateTurret((531, 1314, 89), 0);
	CreateAsc((658, 1283, -15), (658, 1283, 180), 0, 4);
	createFlag((585, -2002, 34), (100, 900, -60), 0);
	ScreateSecretFlag((2665, -3867, 106), (-3531, 1210, 95));
	ScreateSecretFlag((-3813, 1177, 95), (-200, 1219, 176));
	CreateIBlock((-200,1215,115),(0,0,0));
}
Karachi()
{
	CreateWalls((-5017,6,97),(-4974,753,76));
	CreateWalls((-5017,6,45),(-4974,753,14));
	CreateWalls((-4271,654,80),(-4079,664,76));
	CreateWalls((-4271,654,140),(-4079,664,136));
	createFlag((-3695,-766,600),(-3728,-538,170),(0,90,0));
	createFlag((-3418,-549,141),(-3452,-777,600),(0,90,0));
	CreateWalls((-4355,-874,620),(-4348,-80,660));
	CreateWalls((-4348,-80,620),(-4025,-80,660));
	CreateWalls((-4025,-114,630),(-4035,-476,650));
	CreateWalls((-4035,-640,630),(-4035,-865,650));
	CreateWalls((-4066,-467,630),(-4168,-454,650));
	CreateWalls((-4035,-865,620),(-4355,-874,660));
	CreateDoor("force",(-4037,-440,640),(-4037,-575,640),(90,0,0),4,1,40,110);
	CreateDoor("door",(-4132,-481,640),(-4260,-475,640),(90,-90,0),5,1,40,75);
	CreateRamps((-3311,-212,792),(-3687,-224,600));
	CreateBlocks((-3248,-404,785),(0,0,0));
	createFlag((-2659,-119,51),(-4085,125,50));
	createFlag((-3287,-263,78),(-3210,-728,496));
	CreateBlocks((-3093,-195,489),(0,0,0));
	CreateBlocks((-3105,-146,490),(0,0,0));
	CreateRamps((-3044,-133,496),(-2901,610,478));
	CreateBlocks((-3235,-386,774),(0,0,0));
	CreateBlocks((-3293,-409,774),(0,0,0));
	createFlag((-2176,245,0),(-2367,520,0),(0,180,0));
	createFlag((-2367,-129,8),(-2176,50,0));
	createFlag((-4071,-291,611),(-2786,-211,672));
	createFlag((1624,535,47),(-84,4182,20),(0,270,0));
	createFlag((-1049,2423,-9),(1000,2780,112));
	createFlag((680,1842,11),(622,555,48));
	CreateFire((-14,3536,40));
	CreateFire((-109,3475,40));
	CreateFire((-90,2969,20));
	ScreateSecretFlag((-1199,4688,11),(981,1887,40));
	ScreateSecretFlag((804,-671,18),(-1192,3125,38),(0,-90,0));
	CreateTWall((-4861,1496,54),(-1849,521,825),50);
	CreateTWall((-3443,-2000,300),(-3452,-777,600),1050);
	CreateTWall((-2300,-714,155),(-4085,125,50),300);
	CreateFire((888,2048,20));
	CreateAsc((873,2280,-25),(873,2280,168),0,3);
	CreateRamps((1000,2556,120),(1000,2856,80));
	CreateTWall((1000,2780,-70),(1000,2780,112),150);
	CreateTWall((-1876,-2820,395),(-151,656,68),1000);
	CreateTWall((-2571,2157,40),(-151,656,68),1000);
	CreateTWall((-1257,-5259,250),(-151,656,68),750);
	CreateTWall((817,1241,175),(-84,2170,227),50);
	ScreateSecretFlag((-84,1975,227),(175,476,240));
	ScreateSecretFlag((1532,1062,223),(175,476,240));
	ScreateSecretFlag((1350,2087,27),(1676,925,223));
}
Karachi2()
{
	createFlag((-2249,-2298,250),(26,133,400),(0,90,0));
	CreateWalls((-3009,1561,10),(-2858,1812,55));
	CreateWalls((-3240,1455,10),(-3132,1464,65));
	createFlag((-654,1237,11),(-3121,1317,107),(0,90,0));
	createFlag((-1617,2367,10),(4898,397,43),(0,90,0));
	CreateWalls((4974,572,40),(5043,485,160));
	CreateRamps((6447,1595,30),(7087,1840,19));
	CreateWalls((7457,1836,19),(7457,2030,68));
	createFlag((7414,1995,19),(-898,-1631,58),(0,90,0));
	CreateDoor("force",(-2691,1887,40),(-2691,2228,40),(90,0,0),23,1,10,110);
	CreateWalls((-1208,-1446,40),(-1201,-1359,30));
	/*first wall opening*/ 
	CreateWalls((-1283,-2597,80),(-1495,-2810,48));
	/*car wall patch*/ 
	CreateWalls((-790,-3083,108),(-646,-3672,65));
	/*left wall patch*/ 
	CreateWalls((-1179,-3738,72),(-1572,-3465,92));
	/*patch to get out of map*/ 
	CreateWalls((-1617,-3448,-46),(-1795,-2800,68));
	/*wall to door*/ 
	CreateWalls((-1590,-2883,-37),(-1720,-2730,68));
	/*wall opening patch*/ 
	CreateWalls((-1923,-2834,71),(-2281,-2407,40));
	/*back wall*/ 
	CreateWalls((-1742,-2710,61),(-1883,-2534,59));
	/*back wall*/ 
	CreateWalls((-2038,-2179,59),(-2146,-2046,39));
	/*back wall*/ 
	CreateBlocks((-1801,-2805,107),(0,75,0));
	CreateWalls((-2162,-2009,253),(-1993,-1871,214));
	/*top floor*/ 
	CreateWalls((-1981,-2240,230),(-1801,-2081,211));
	/*top floor*/ 
	CreateWalls((-2110,-2233,224),(-2043,-2242,175));
	/*top floor*/ 
	CreateBlocks((-1958,-2331,71),(0,125,0));
	CreateBlocks((-1961,-2181,221),(0,42,0));
	CreateBlocks((-1852,-2087,221),(0,42,0));
	CreateBlocks((-1880,-1954,258),(52,0,0));
	CreateBlocks((-1943,-1872,273),(52,0,0));
	CreateBlocks((-1862,-1978,273),(50,0,52));
	CreateBlocks((-1821,-2022,273),(0,52,52));
	CreateBlocks((-1899,-1918,273),(50,0,52));
	CreateBlocks((-2224,-2202,264),(0,90,90));
	CreateBlocks((-1996,-2211,200),(90,90,90));
	CreateTurret((-949,-3719,52), (0, 91, 0));
}
Skidrow()
{
	CreateDoor("door",(1059,-808,0),(1321,-808,0),(90,0,90),9,2,30,100);
	CreateDoor("door",(992,-250,0),(992,-105,0),(90,0,0),10,2,30,100);
	CreateWalls((992,374,0),(992,62,97));
	CreateBlocks((941,236,95),(0,0,0));
	CreateRamps((1807,-217,100),(1470,-217,190));
	CreateRamps((1976,-462,50),(1976,-549,95));
	CreateDoor("door",(883,-1799,32),(990,-1799,32),(90,0,90),7,2,30,100);
	CreateDoor("door",(727,-1904,32),(727,-1951,32),(90,0,0),2,2,30,100);
	CreateBlocks((837,-2176,176),(0,90,0));
	CreateBlocks((837,-2129,176),(0,90,0));
	CreateDoor("door",(-2167,278,16),(-2167,215,16),(90,0,0),3,2,30,120);
	CreateDoor("door",(-2271,-912,128),(-2209,-912,128),(90,0,90),3,2,30,120);
	level thread CreateKillIfBelow(-180);
	CreateTWall((1921, 1186, 131), (145, 16, 30), 500);
	createFlag((-521, 917, 91), (2729, 1181, 129), (0, 0, 0));
	CreateTWall((6010, 1211, 131), (-1743, -527, 139), 2100);
	CreateTWall((-208, 533,475), (-1743, -527, 139), 250);
	//MakeTeleZone((3274.06, 1169.87, -695.384), undefined, (0,0,0),"kill");
}
Skidrow2()
{
	CreateWalls((2015, -814, 20), (2070, -814, 80));
	CreateWalls((1583, -1520, 20), (1733, -1520, 50));
	CreateWalls((1887, -1520, 20), (2077, - 1520, 80));
	CreateWalls((2037, -1540, 20), (2037, -1860, 50));
	CreateWalls((2077, -1870, 20), (1591, -1870, 80));
	createFlag((1959, -922, 0), (1416, 419, 8));
	CreateDoor("door",(1625, -1550, 45), (1815, -1520, 45), (90,90, 0),4, 1, 55, 105);
	createFlag((1484, -1632, 0), (1683, -921, 0));
	CreateTWall((1834, -2466, 52), (-2302, -527, 139), 500);
	CreateWalls((3736, 1020, 125), (3736, 1332, 185));
	CreateGrids((3736, 1042, 125), (3500, 1302, 125));
	CreateTWall((6010, 1211, 131), (-2302, -527, 139), 2100);
	level thread CreateKillIfBelow(-180);
	CreateTWall ((1921, 1186, 131), (145, 16, 30), 500);
	createFlag((-521, 917, 91), (2729, 1181, 129), (0, 0, 0));
	CreateIWall((2650, 1042, 130), (2650, 1302, 190));
	CreateIBlock((239, -543, 60));
	CreateIBlock((200, -543, 30));
	CreateIBlock((181, -547, 0));
	CreateTWall((470, -569, 20), (3837, 1298, 130), 50);
	CreateTWall((-208, 533,475), (-1743, -527, 139), 250);
	//MakeTeleZone((3274.06, 1169.87, -695.384),undefined, (0,0,0),"kill");
}
Skidrow3()
{
	level thread CreateKillIfBelow(-3161);
	createFlag((-725, -410, 136), (-307, -987, 608), (0, 0, 0));
	CreateRamps((1690, 325, 213), (1890, 325, 108));
	CreateRamps((840, -646, 649), (560,-644.81, 569));
	CreateGrids((845.850, -865.085, 654), (1014, -572, 654));
	CreateWalls((824, -565, 774), (1030, -568, 638));
	CreateWalls((826, -872, 655), (1029, -877, 815));
	CreateWalls((823, -693, 651), (823, -874, 778));
	CreateGrids((845, -853, 781), (952, -588, 781));
	CreateRamps((999, -774, 669), (1000, -596, 777));
	CreateDoor("door",(824.5, -749, 708), (822, -662, 708), (0,-90,90), 3, 2, 20, 75);
	CreateTWall((-208, 533,475), (-1743, -527, 139), 250);
	CreateBlocks((-705,-121,618),(90,0,0));
	CreateTWall((-448, -1573,624), (-1743, -527, 139), 300);
	CreateTWall((-1124, -1576,624), (-1743, -527, 139), 200);
	CreateTWall((-271, -1526,619), (-1743, -527, 139), 10);
	//MakeTeleZone((3274.06, 1169.87, -695.384), undefined, (0,0,0),"kill");
}
Scrapyard()
{
	CreateBlocks((-1457,-144,-68),(0,90,90));
	CreateBlocks((-1487,856,-68),(0,90,90));
	CreateBlocks((787,-521,-96),(0,90,0));
	CreateDoor("force",(-1280,534,-88),(-1280,680,-88),(90,0,0),4,2,50,75);
	CreateDoor("force",(170,-547,-96),(170,-445,-96),(90,0,0),5,1,50,75);
	CreateDoor("force",(517,-273,-96),(663,-273,-96),(90,0,90),5,2,50,75);
	/*added another layer to prevent jumping over the barrier*/ 
	CreateBlocks((2099,-61,-112),(90,0,0));
	createFlag((206,-319,-125),(-2810,884,1399));
	createFlag((-428,0,1558),(1943,-614,-116));
	CreateRamps((-1330,-86,135),(-1575,-74,-10));
	CreateFire((-1326,158,155));
	CreateRamps((393,1633,175),(887,1619,156));
	createFlag((-876,1410,-128),(820,1635,200));
	CreateFire((413,1649,205));
	CreateFire((630,1644,195));
	CreateTWall((-2810,884,599),(1943,-614,-116),700);
	CreateTWall((86,-2107,100),(1943,-614,-116),1000);
	level thread CreateKillIfBelow(-280);
	createFlag((-1820,1256,-110),(-1614,927,-119));
	createFlag((10,1659,-72),(860,1606,194),(0,180,0));
	CreateDoor("force",(1992,266,-130),(1992,336,-130),(90,0,0),2,2,50,50);
	CreateDoor("force",(1992,710,-130),(1992,640,-130),(90,0,0),2,2,50,50);
	createFlag((-3640,6481,2480),(-1181,1306,-127));
	createFlag((-256,348,-110),(-5104,4405,2309));
}

Storm()
{
	CreateBlocks((-786.741, -424.559, 140.125),(0,90,90));
	CreateBlocks((355.644, -825.962, 64.125),(90,90,0));
	CreateBlocks((-652.642, -386.035, 170.125),(90,90,0));
	CreateBlocks((-875.116, 186.821, 50.125005),(90,90,0));
	CreateBlocks((781.304, 901.642, 170.125),(90,90,0));
	CreateBlocks((814.522, 900.613, 170.125),(90,90,0));
	CreateHiddenBlocks((976.532, -600.132, 78.5518),(90,90,0));
	CreateHWalls((184.875, -388.113, 180.125),(-434.875, -388.566, 181.125));
	CreateWalls((755.99, -590.856, 47.124999),(882.976, -596.703, 50.9726));
	CreateWalls((755.99, -590.856, 1.124999),(882.976, -596.703, 0.9726));
	CreateDoor("door",(878.875, -944.875, 0.125002),(710.334, -950.682, 0.123),(90,0,90),4,2,25,100);//First door
	CreateDoor("door",(-306.304, -1862.82, 10.9091),(-299.523, -1707.98, 16.125),(90,0,0),4,2,25,100);//down stairs by elev
	CreateDoor("door",(-1275.97, -1020.28, 180.02),(-1274.66, -1080.2, 180.125),(90,0,0),1,1,50,100);//single block
	CreateDoor("door",(518.236, -730.175, 40.651543),(513.989, -770.078, 40.125002),(90,0,0),1,1,25,100);//single block 2
	CreateDoor("door",(-711.408, -841.557, 175.265),(-651.373, -842.317, 175.125),(90,0,90),3,1,10,100);//double block 
	CreateDoor("door",(-680.986, -1621.37, 139.222),(-799.944, -1619.21, 136.125),(90,0,90),4,2,25,100);//Up stairs by elev
	CreateHiddenFlag((-868.282, 156.696, -0.103679), (-880.338, 240.307, -7.875), (0, 180, 0));
	CreateHiddenFlag((809.312, 849.048, 128.125), (795.097, 987.077, 128.125), (0, 180, 0));
	createFlag((-486.557, -418.622, 128.125), (2738.01, -715.667, 624.125), (0, 180, 0));
	CreateRamps((3026.08, -828.137, 624.125), (3261.54, -1172.76, 662.118));
	CreateWalls((3259.29, -1108.33, 672.409),(3263.77, -898.404, 767.766));
	CreateRamps((3263.43, -1437.05, 662.057), (3532.09, -1449.7, 662.003));
	CreateRamps((3534, -823.169, 662.125), (3806.06, -817.089, 662.124));
	CreateRamps((3806.88, -1465.15, 660.297), (4119.43, -1451.64, 662.057));
	createFlag((4117.18, -797.699, 662.103), (907.669, -1328.45, 39.8441), (0, 180, 0));
	CreateHWalls((2147.59, -964.871, -30.4411),(2129.04, -1329.38, -29.7299));
	CreateHWalls((1938.66, -1044.87, 20.875),(1943.23, -975.125, -7.875));
	CreateHWalls((-1235.66, -855.87, 139.875),(-1082.23, -856.125, 210.875));
	MakeTeleZone((4000.99, -1184.22, -50.855), (907.669, -1328.45, 39.8441), (0,0,0), "Team");
}
NukeTown()
{
	CreateRamps((-497.879, 243.476, 75.125), (-93.6289, -422.855, 74.2046));
	CreateRamps((-112.113, -417.063, 75.774), (602.999, 4.04151, 74.3982));
	CreateRamps((-98.5396, -410.876, 75.1917), (-124.551, -568.654, 74.1854));
	CreateRamps((340.879, -1080.476, -35.125), (350.6289, -1159.855, -33.2046));
	CreateDoor("door",(758.474, 302.224, 130.125), (798.201, 241.833, 130.125), (90, 0, -20), 2, 1, 50, 150);
	CreateDoor("door",(-699.474, 432.865, 130.125),(-741.9, 373.237, 130.125), (90, 0, 20), 2, 1, 50, 150);
	CreateDoor("force",(-327.855, -1393.19, 41.8288),(-258.333, -1470.35, 40.1609), (90, 0, 150), 6, 1, 25, 150);
	CreateHWalls((-204.805, -1560.17, 37.9344), (-96.45, -1757.36, 37.1787));
	CreateRamps((492.972, -1109.38, -28.7257), (-331.577, -1521.94, -28.242));
	CreateRamps((-316.04, -1514.15, -28.1845), (-111.936, -2271.66, -28.3047));
	createFlag((-119.827, -555.843, 89.3954), (354.214, -1052.63, -5.57433));
	createFlag((-96.3828, -2344.06, -5.9359), (-46.3819, 278.631, -16.012));
}

MakeTeleZone(enter, exit, angle, reason)
{
	Kill = spawn( "trigger_radius", enter, 0, 1500, 600 );
	Kill.angles = angle;
	Kill thread TeleZoneTrig(enter,exit,angle, reason);
}

TeleZoneTrig(enter,exit,angle,reason)
{
	self endon("death");
	level endon("game_ended");
	while(isdefined(self))
	{
		self waittill( "trigger", player );
		if(player.team != "allies")
		{
			player _suicide();
		}
		else
		{
			player SetOrigin(exit);
			player SetPlayerAngles(angle);
		}
		//player iprintln("ffffdds");
		waitframe();
	}
}
CreateKillIfBelow(killheight){
	while(level.gameState != "ending")
	{
		foreach(player in level.players)
		{
			if(player.origin[2] < killheight)
				player suicide();
		}
		wait 2;
	}
}

CreateHiddenBlocks(pos, angle)
{
	block = spawn("script_model", pos );
	//block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
	block.angles = angle;
	block Solid();
	block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
	wait 0.01;
}
CreateHWalls(start, end)
{
	D = Distance((start[0], start[1], 0), (end[0], end[1], 0));
	H = Distance((0, 0, start[2]), (0, 0, end[2]));
	blocks = roundUp(D/55);
	height = roundUp(H/30);
	CX = end[0] - start[0];
	CY = end[1] - start[1];
	CZ = end[2] - start[2];
	XA = (CX/blocks);
	YA = (CY/blocks);
	ZA = (CZ/height);
	TXA = (XA/4);
	TYA = (YA/4);
	Temp = VectorToAngles(end - start);
	Angle = (0, Temp[1], 90);
	for(h = 0; h < height; h++){
		block = spawn("script_model", (start + (TXA, TYA, 10) + ((0, 0, ZA) * h)));
		//block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		wait 0.001;
		for(i = 1; i < blocks; i++){
			block = spawn("script_model", (start + ((XA, YA, 0) * i) + (0, 0, 10) + ((0, 0, ZA) * h)));
			//block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
			block.angles = Angle;
			block Solid();
			block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
			wait 0.001;
		}
		block = spawn("script_model", ((end[0], end[1], start[2]) + (TXA * -1, TYA * -1, 10) + ((0, 0, ZA) * h)));
		///block setModel("com_plasticcase_friendly");level.carepackagesSpawned++;
		block.angles = Angle;
		block Solid();
		block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
		wait 0.001;
	}
}
